-- -------------------------------------------------------------------- 
-- >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<< 
-- -------------------------------------------------------------------- 
-- Copyright (c) 2001 by Lattice Semiconductor Corporation 
-- -------------------------------------------------------------------- 
-- 
-- 
--                     Lattice Semiconductor Corporation 
--                     5555 NE Moore Court 
--                     Hillsboro, OR 97214 
--                     U.S.A 
-- 
--                     TEL: 1-800-Lattice (USA and Canada) 
--                          408-826-6000 (other locations) 
-- 
--                     web: http://www.latticesemi.com/ 
--                     email: techsupport@latticesemi.com 
-- 
-- -------------------------------------------------------------------- 
-- 
-- Simulation package file for ispMACh components, it work for all the generic CPLD of Lattice products
-- 
-- Revision History:
-- -------------------------------------------------------------------- 
--$Header: R:/src/mod_kits/Mach/vital/rcs/MACH.vhd 1.9 2004/02/13 23:02:11Z jli Exp $
----------------------------------------------------------------
-- 
-- FILE CONTENTS:    MACH VITAL Library 
-- DATE CREATED :    Wen Sept  15 1998
-- 
-- LIBRARY      :    MACH
-- REVISION     :    1.2 
-- TIME SCALE   :    1 ns
-- LOGIC SYSTEM :    IEEE-1164
-- NOTES        :    
-- HISTORY      :
-- 
-- version 1.0, Initial beta version for beta testing 
-- version 1.1, Change the array size to pass model tech.
-- version 1.2, Change the default for setup and hold for DFF/TFF/DLAT
--              Modified the index range to pass Modelsim EE 5.2e warnings
-- version 1.3, Change the default pw, period for FF and LATCH.

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.VITAL_timing.all;
USE IEEE.VITAL_primitives.all;
 
 
package VLOGTOVITAL_TABLES is
 
---------------------------------------------------------------------------------
-- Local type declaration
---------------------------------------------------------------------------------

    TYPE edge_table IS ARRAY (std_ulogic, std_ulogic) OF boolean ;

---------------------------------------------------------------------------------
-- Contants Specifications
-- posedge, negedge
---------------------------------------------------------------------------------
    CONSTANT POSEDGE : edge_table := (
    --      ---------------------------------------------------------
    --      |  U      X      0      1      Z      W      L      H      - |   |
    --      ---------------------------------------------------------
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | U |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | X |
            ( FALSE, TRUE,  FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 0 |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 1 |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | Z |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | W |
            ( FALSE, TRUE,  FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | L |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE ), -- | H |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE )  -- | - |
        );

    CONSTANT NEGEDGE : edge_table := (
    --      ---------------------------------------------------- -----
    --      |  U    X    0    1    Z    W    L    H    - |   |
    --      ---------------------------------------------------- -----
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | U |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | X |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 0 |
            ( FALSE, TRUE,  TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 1 |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | Z |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | W |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | L |
            ( FALSE, TRUE,  TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | H |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE )  -- | - |
        );

        -------------------------------------------------------------------------------
        --State Table Declaration
        -------------------------------------------------------------------------------

	CONSTANT dfftab : VitalStateTableType := (
	-- D CLK R S lstSt Q
	( '-', '-', '0', '1', '-', '0' ),
	( '-', '-', '1', '0', '-', '1' ),
	( '1', '/', '1', '-', '-', '1' ),
	( '0', '/', '-', '1', '-', '0' ),
	( '1', '-', '1', '*', '1', '1' ),
	( '-', '0', '1', '*', '1', '1' ),
	( '-', '1', '1', '*', '1', '1' ),
	( '1', '-', '0', '\', '0', 'X' ),---
	( '-', '0', '0', '\', '0', 'X' ),---
	( '-', '1', '0', '\', '0', 'X' ),---
	( '0', '-', '*', '1', '0', '0' ),
	( '-', '0', '*', '1', '0', '0' ),
	( '-', '1', '*', '1', '0', '0' ),
	( '0', '-', '\', '0', '1', 'X' ),--
	( '-', '0', '\', '0', '1', 'X' ),--
	( '-', '1', '\', '0', '1', 'X' ),--
	( '1', 'R', '1', '1', '1', '1' ),
	( '0', 'R', '1', '1', '0', '0' ),
	( '-', '\', '-', '-', '-', 'S' ),
	( '-', 'v', '-', '-', '-', 'S' ),
	( '0', 'r', '-', '-', '0', 'S' ),
	( '0', 'f', '-', '-', '0', 'S' ),
	( '1', 'r', '-', '-', '1', 'S' ),
	( '1', 'f', '-', '-', '1', 'S' ),
	( '*', '1', '-', '-', '-', 'S' ),
	( '*', '0', '-', '-', '-', 'S' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT latchtab : VitalStateTableType := (
	-- D LAT R S lstSt Q
	( '-', '-', '0', '1', '-', '0' ),
	( '-', '-', '1', '0', '-', '1' ),
	( '*', '0', '1', '1', '-', 'S' ),
	( '-', '\', '1', '1', '-', 'S' ),
	( '-', 'v', '1', '1', '-', 'S' ),
	( '-', 'f', '1', '1', '-', 'S' ),
	( '0', '^', '-', '1', '-', '0' ),
	( '1', '^', '1', '-', '-', '1' ),
	( '0', 'r', '1', '1', '0', '0' ),
	( '1', 'r', '1', '1', '1', '1' ),
	( '\', '1', '-', '1', '-', '0' ),
	( 'v', '1', '-', '1', '-', '0' ),
	( '/', '1', '1', '-', '-', '1' ),
	( '^', '1', '1', '-', '-', '1' ),
	( '0', '/', '-', '1', '-', '0' ),
	( '1', '/', '1', '-', '-', '1' ),
	( '-', '0', '1', '/', '-', 'S' ),
	( '-', '0', '1', '^', '-', 'S' ),
	( '-', '0', '/', '1', '-', 'S' ),
	( '-', '0', '^', '1', '-', 'S' ),
	( '0', '1', '-', '/', '-', '0' ),
	( '0', '1', '-', '^', '-', '0' ),
	( '1', '1', '/', '-', '-', '1' ),
	( '1', '1', '^', '-', '-', '1' ),
	( '1', '1', '1', '/', '-', '1' ),
	( '1', '1', '1', '^', '-', '1' ),
	( '0', '1', '/', '1', '-', '0' ),
	( '0', '1', '^', '1', '-', '0' ),
	( '/', 'X', '1', '-', '1', '1' ),
	( '^', 'X', '1', '-', '1', '1' ),
	( '\', 'X', '-', '1', '0', '0' ),
	( 'v', 'X', '-', '1', '0', '0' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT jkfftab : VitalStateTableType := (
	-- CLK J K S R lstSt Q
	( '-', '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '-', '1', '0', '-', '0' ),
	( '-', '-', '-', '*', '1', '1', '1' ),
	( '-', '-', '-', '1', '*', '0', '0' ),
	( '/', '0', '0', '1', '1', '-', 'S' ),
	( '/', '0', '1', '1', '1', '-', '0' ),
	( '/', '1', '0', '1', '1', '-', '1' ),
	( '/', '1', '1', '1', '1', '1', '0' ),
	( '/', '1', '1', '1', '1', '0', '1' ),
	( '\', '-', '-', '-', '-', '-', 'S' ),
	( 'B', '*', '-', '-', '-', '-', 'S' ),
	( 'B', '-', '*', '-', '-', '-', 'S' ),
	( 'R', '0', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '-', '1', '-', '0', 'S' ),
	( 'R', '-', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '0', '1', '1', '-', 'S' ),
	( 'f', '0', '-', '1', '-', '0', 'S' ),
	( 'f', '-', '0', '-', '1', '1', 'S' ),
	( 'X', '*', '0', '-', '1', '1', 'S' ),
	( 'X', '0', '*', '1', '-', '0', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT rsfftab : VitalStateTableType := (
	-- CLK RE SE S R lstSt Q
	( '-', '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '-', '1', '0', '-', '0' ),
	( '-', '1', '1', '/', '1', '-', 'S' ),
	( '-', '1', '1', '^', '1', '-', 'S' ),
	( '-', '1', '1', '1', '/', '-', 'S' ),
	( '-', '1', '1', '1', '^', '-', 'S' ),
	( '/', '0', '0', '1', '1', '-', 'S' ),
	( '/', '0', '1', '1', '1', '-', '1' ),
	( '/', '1', '0', '1', '1', '-', '0' ),
	( '\', '-', '-', '-', '-', '-', 'S' ),
	( 'R', '0', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '-', '1', '-', '0', 'S' ),
	( 'R', '-', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '0', '1', '1', '-', 'S' ),
	( 'f', '0', '-', '1', '-', '0', 'S' ),
	( 'f', '-', '0', '-', '1', '1', 'S' ),
	( 'X', '*', '0', '-', '1', '1', 'S' ),
	( 'X', '0', '*', '1', '-', '0', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', '/', '-', 'S' ),----
	( 'S', 'S', 'S', '/', 'S', '-', 'S' ),----
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),----
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ),
	( '-', '*', '-', '1', '1', '-', 'S' ),
	( '-', '-', '*', '1', '1', '-', 'S' ));


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT tfftab : VitalStateTableType := (
	-- CLK T S R lstSt Q
	( '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '1', '0', '-', '0' ),
	( 'X', '0', '1', '-', '0', 'S' ),
	( '-', '-', '*', '1', '1', '1' ),
	( '-', '-', '1', '*', '0', '0' ),
	( '/', '0', '1', '1', '-', 'S' ),
	( '/', '1', '1', '1', '1', '0' ),
	( '/', '1', '1', '1', '0', '1' ),
	( '\', '-', '-', '-', '-', 'S' ),
	( 'B', '*', '-', '-', '-', 'S' ),
	( 'R', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '1', '-', '0', 'S' ),
	( 'R', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '1', '1', '-', 'S' ),
	( 'f', '-', '-', '1', '1', 'S' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT dffcetab : VitalStateTableType := (
	-- D CLK R S CE lstSt Q
	( '-', '-', '0', '1', '-', '-', '0' ),
	( '-', '-', '1', '0', '-', '-', '1' ),
	( '-', '-', '1', '1', '0', '-', 'S' ),
	( '1', '/', '1', '-', '1', '-', '1' ),
	( '0', '/', '-', '1', '1', '-', '0' ),
	( '1', '-', '1', '*', '1', '1', '1' ),
	( '-', '0', '1', '*', '1', '1', '1' ),
	( '-', '1', '1', '*', '1', '1', '1' ),
	( '0', '-', '*', '1', '1', '0', '0' ),
	( '-', '0', '*', '1', '1', '0', '0' ),
	( '-', '1', '*', '1', '1', '0', '0' ),
	( '1', 'R', '1', '1', '1', '1', '1' ),
	( '0', 'R', '1', '1', '1', '0', '0' ),
	( '-', '\', '-', '-', '1', '-', 'S' ),
	( '-', 'v', '-', '-', '1', '-', 'S' ),
	( '0', 'r', '-', '-', '1', '0', 'S' ),
	( '0', 'f', '-', '-', '1', '0', 'S' ),
	( '1', 'r', '-', '-', '1', '1', 'S' ),
	( '1', 'f', '-', '-', '1', '1', 'S' ),
	( '*', '1', '-', '-', '1', '-', 'S' ),
	( '*', '0', '-', '-', '1', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
--	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),
--	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( '\', 'S', 'S', 'S', 'X', '-', 'S' ),
	( '/', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( '-', '-', '1', '1', '*', '-', 'S' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ) );


end VLOGTOVITAL_TABLES;
 
----- VITAL model for cell AND2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND2 : entity is TRUE;
end AND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of AND2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_AND2_VITAL of AND2 is 
        for VITAL
        end for; 
end CFG_AND2_VITAL;
----- VITAL model for cell AND3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND3 : entity is TRUE;
end AND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of AND3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd) AND (I2_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_AND3_VITAL of AND3 is 
        for VITAL
        end for; 
end CFG_AND3_VITAL;
----- VITAL model for cell AND4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND4 : entity is TRUE;
end AND4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of AND4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_AND4_VITAL of AND4 is 
        for VITAL
        end for; 
end CFG_AND4_VITAL;
----- VITAL model for cell AND5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND5 : entity is TRUE;
end AND5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of AND5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND5_VITAL of AND5 is 
        for VITAL
        end for; 
end CFG_AND5_VITAL;
----- VITAL model for cell AND6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND6 : entity is TRUE;
end AND6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of AND6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd) AND
         (I5_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND6_VITAL of AND6 is 
        for VITAL
        end for; 
end CFG_AND6_VITAL;
----- VITAL model for cell AND7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND7 : entity is TRUE;
end AND7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of AND7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd) AND
         (I5_ipd) AND (I6_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND7_VITAL of AND7 is 
        for VITAL
        end for; 
end CFG_AND7_VITAL;
----- VITAL model for cell AND8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND8 : entity is TRUE;
end AND8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of AND8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd) AND
         (I5_ipd) AND (I6_ipd) AND (I7_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND8_VITAL of AND8 is 
        for VITAL
        end for; 
end CFG_AND8_VITAL;


----- CELL MUX2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX2 : entity is TRUE;
end MUX2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, S0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I1_ipd, I0_ipd),
                  dselect => (0 => S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX2_VITAL of MUX2 is
   for VITAL
   end for;
end CFG_MUX2_VITAL;


----- CELL MUX4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX4 : entity is TRUE;
end MUX4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   VitalWireDelay (S1_ipd, S1, tipd_S1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, S0_ipd, S1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I3_ipd, I2_ipd, I1_ipd, I0_ipd),
                  dselect => (S1_ipd, S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (S0_ipd'last_event, tpd_S0_O, TRUE),
                 5 => (S1_ipd'last_event, tpd_S1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX4_VITAL of MUX4 is
   for VITAL
   end for;
end CFG_MUX4_VITAL;
 
----- VITAL model for cell BI_DIR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity BI_DIR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN        : string  := "Off";
      PULL           : string  := "Off";
      tpd_OE_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I0_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BI_DIR : entity is TRUE;
end BI_DIR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of BI_DIR is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (IO_ipd, IO, tipd_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------

   VITALBehavior : process (OE_ipd, I0_ipd, IO_ipd)


   -- functionality results
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
     VARIABLE IO_GlitchData	: VitalGlitchDataType;
     VARIABLE O_GlitchData	: VitalGlitchDataType;
     VARIABLE IO_zd : std_ulogic ;

   begin
      -------------------------
      --  Functionality Section
      -------------------------

      if (OE_ipd = '0') then
         IO_zd := 'Z';
      elsif (OE_ipd = '1') then
         if (OUTOPEN = "Off") then
             IO_zd := TO_X01(I0_ipd);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
             if (I0_ipd = '0') then
                IO_zd := '0';
             elsif (I0_ipd = '1') then
              if (PULL = "Off") then
                IO_zd := 'Z';
              elsif (PULL = "Up") then
                IO_zd := 'H';
              elsif (PULL = "Down") then
                IO_zd := 'L';              
              elsif (PULL = "Hold") then
                IO_zd := IO_zd;              
              else
                IO_zd := 'Z';            
              end if;          
             else
                IO_zd := 'X';
             end if;
         end if;
      end if;


      if (PULL = "Off") then
           O_zd := TO_X01(IO_ipd);
      elsif (PULL = "Up") then
           CASE TO_X01Z(IO_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '1';
              WHEN others => O_zd := 'X';
           END CASE;
      elsif (PULL = "Down") then
           CASE TO_X01Z(IO_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '0';
              WHEN others => O_zd := 'X';
           END CASE;
      elsif (PULL = "Hold") then
           CASE TO_X01Z(IO_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := O_zd;
              WHEN others => O_zd := 'X';
           END CASE;
      end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_IO), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (IO_ipd'last_event, tpd_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BI_DIR_VITAL of BI_DIR is 
        for VITAL
        end for; 
end CFG_BI_DIR_VITAL;

----- VITAL model for cell BUFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFF : entity is TRUE;
end BUFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of BUFF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BUFF_VITAL of BUFF is 
        for VITAL
        end for; 
end CFG_BUFF_VITAL;

----- VITAL model for cell BUFTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN        : string := "Off";
      tpd_OE_O                       :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFTH : entity is TRUE;
end BUFTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of BUFTH is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------

       if (OE = '0') then
          O_zd := 'Z';
       elsif (OE = '1') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_ipd);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_ipd = '0') then
              O_zd := '0';
           elsif (I0_ipd = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_BUFTH_VITAL of BUFTH is 
        for VITAL
        end for; 
end CFG_BUFTH_VITAL;

----- VITAL model for cell BUFTL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFTL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN       : string := "Off";
      tpd_OE_O                       :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFTL : entity is TRUE;
end BUFTL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of BUFTL is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       if (OE = '1') then
          O_zd := 'Z';
       elsif (OE = '0') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_ipd);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_ipd = '0') then
              O_zd := '0';
           elsif (I0_ipd = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;
      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_BUFTL_VITAL of BUFTL is 
        for VITAL
        end for; 
end CFG_BUFTL_VITAL;

----- VITAL model for cell CLKI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CLKI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_PAD_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_PAD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CLKI : entity is TRUE;
end CLKI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of CLKI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(PAD_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (PAD_ipd'last_event, tpd_PAD_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_CLKI_VITAL of CLKI is 
        for VITAL
        end for; 
end CFG_CLKI_VITAL;

----- VITAL model for cell DFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 1.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 1.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFF : entity is TRUE;
end DFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY; 

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, R ,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFF_VITAL of DFF is 
        for VITAL
        end for; 
end CFG_DFF_VITAL;

----- VITAL model for cell DFFC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge        :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 1.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFC : entity is TRUE;
end DFFC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFC is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY; 

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) = '1',
          HeaderMsg               => InstancePath & "/DFFC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_posedge or Tviol_CE_CLK_posedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly, R ,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFC_VITAL of DFFC is 
        for VITAL
        end for; 
end CFG_DFFC_VITAL;

----- VITAL model for cell DFFCR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCR : entity is TRUE;
end DFFCR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFCR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_1_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge or Tviol_CE_CLK_R_EQ_1_posedge or Tviol_R_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,R_CLK_dly,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCR_VITAL of DFFCR is 
        for VITAL
        end for; 
end CFG_DFFCR_VITAL;
----- VITAL model for cell DFFCRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge 		:	VitalDelayType := 1.000 ns;
      tpw_R_posedge 		:	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCRH : entity is TRUE;
end DFFCRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFCRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R				: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R				: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_0_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(NOT R_CLK_dly)= '1', 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_R_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge or Tviol_CE_CLK_R_EQ_0_posedge or Tviol_R_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,R_inverted,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCRH_VITAL of DFFCRH is 
        for VITAL
        end for; 
end CFG_DFFCRH_VITAL;

----- VITAL model for cell DFFCS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCS : entity is TRUE;
end DFFCS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFCS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_CE_CLK_S_EQ_1_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_S_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                          TO_X01((S_CLK_dly) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge or Tviol_CE_CLK_S_EQ_1_posedge or Tviol_S_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,'1',S_CLK_dly, CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCS_VITAL of DFFCS is 
        for VITAL
        end for; 
end CFG_DFFCS_VITAL;
----- VITAL model for cell DFFCSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tpw_S_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCSH : entity is TRUE;
end DFFCSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFCSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_CE_CLK_S_EQ_0_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(NOT S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_S_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge or Tviol_CE_CLK_S_EQ_0_posedge or Tviol_S_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,'1', S_inverted, CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCSH_VITAL of DFFCSH is 
        for VITAL
        end for; 
end CFG_DFFCSH_VITAL;

----- VITAL model for cell DFFCRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFFCRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCRS : entity is TRUE;
end DFFCRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFCRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_CLK_dly, CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE CE_delayed : STD_ULOGIC := 'X';
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_CLK_dly) AND (S_CLK_dly))
                            /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TO_X01(R_CLK_dly AND S_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( (NOT S_CLK_dly) ) OR ( (NOT R_CLK_dly) )
                            ) /= '1',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge or Tviol_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge or Tviol_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge or Pviol_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1 or Tviol_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge;
      CE_delayed := CE_CLK_dly;
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_delayed, CLK_delayed, R_CLK_dly, S_CLK_dly,CE_delayed ));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCRS_VITAL of DFFCRS is 
        for VITAL
        end for; 
end CFG_DFFCRS_VITAL;
----- VITAL model for cell DFFCRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DFFCRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_posedge :	VitalDelayType := 1.000 ns;
      tpw_S_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCRSH : entity is TRUE;
end DFFCRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFCRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';


begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_CLK_dly, CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE CE_delayed : STD_ULOGIC := 'X';
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_CLK_dly) AND ((NOT
                            S_CLK_dly))) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((NOT R_CLK_dly) AND (NOT S_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_CLK_dly ) OR ( R_CLK_dly ) ) /= '1',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge or Tviol_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge or Tviol_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge or Tviol_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge or Pviol_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0 or Pviol_R or Pviol_S;
      CE_delayed := CE_CLK_dly;
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      R_inverted := (NOT R_CLK_dly);
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_delayed, CLK_delayed,R_inverted,S_inverted,CE_delayed));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCRSH_VITAL of DFFCRSH is 
        for VITAL
        end for; 
end CFG_DFFCRSH_VITAL;

----- VITAL model for cell DFFR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFR : entity is TRUE;
end DFFR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_R_EQ_1_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
              D_CLK_dly, CLK_dly, R_CLK_dly, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFR_VITAL of DFFR is 
        for VITAL
        end for; 
end CFG_DFFR_VITAL;
----- VITAL model for cell DFFRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tpw_R_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRH : entity is TRUE;
end DFFRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_R_EQ_0_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, R_inverted, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRH_VITAL of DFFRH is 
        for VITAL
        end for; 
end CFG_DFFRH_VITAL;
----- VITAL model for cell DFFRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFFRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_negedge :	VitalDelayType := 1.000 ns;
      tpw_S_negedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge   :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRS : entity is TRUE;
end DFFRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1_AN_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE Pviol_R			: STD_ULOGIC := '0';
   VARIABLE Pviol_S			: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1_AN_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R			: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S			: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1_AN_S_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1_AN_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( (NOT S_CLK_dly) ) OR ( (NOT R_CLK_dly) )
                            ) /= '1',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      Violation := Tviol_D_CLK_R_EQ_1_AN_S_EQ_1_posedge or Tviol_R_CLK_S_EQ_1_posedge or Tviol_S_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1_AN_S_EQ_1 or Pviol_R or Pviol_S;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_delayed, CLK_delayed, R_CLK_dly, S_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRS_VITAL of DFFRS is 
        for VITAL
        end for; 
end CFG_DFFRS_VITAL;
----- VITAL model for cell DFFRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFFRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge 		     :	VitalDelayType := 1.000 ns;
      tpw_R_posedge 		     :	VitalDelayType := 1.000 ns;
      tpw_S_posedge 		     :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge   	     :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge     :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge     :	VitalDelayType := 0.000 ns;
      ticd_CLK                        :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                      :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                      :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                      :	VitalDelayType := 0.000 ns;
      tipd_D                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                          :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRSH : entity is TRUE;
end DFFRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0_AN_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R			: STD_ULOGIC := '0';
   VARIABLE Pviol_S			: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0_AN_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R			: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S			: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE R_inverted: STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND ((NOT R_CLK_dly))) /=
                            '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT S_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0_AN_S_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0_AN_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_CLK_dly ) OR ( R_CLK_dly ) ) /= '1',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      R_inverted := NOT R_CLK_dly;
      S_inverted := NOT S_CLK_dly;
      Violation := Tviol_D_CLK_R_EQ_0_AN_S_EQ_0_posedge or Tviol_R_CLK_S_EQ_0_posedge or Tviol_S_CLK_R_EQ_0_posedge or Pviol_CLK_R_EQ_0_AN_S_EQ_0 or Pviol_R or Pviol_S;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_delayed, CLK_delayed, R_inverted, S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRSH_VITAL of DFFRSH is 
        for VITAL
        end for; 
end CFG_DFFRSH_VITAL;

----- VITAL model for cell DFFS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFS : entity is TRUE;
end DFFS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_1,
          PeriodData              => PInfo_CLK_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_S_EQ_1_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, '1', S_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFS_VITAL of DFFS is 
        for VITAL
        end for; 
end CFG_DFFS_VITAL;
----- VITAL model for cell DFFSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tpw_S_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFSH : entity is TRUE;
end DFFSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DFFSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_0,
          PeriodData              => PInfo_CLK_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_S_EQ_0_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_0;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, '1', S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFSH_VITAL of DFFSH is 
        for VITAL
        end for; 
end CFG_DFFSH_VITAL;
----- VITAL model for cell DLAT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLAT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge            :	VitalDelayType := 1.000 ns;
      tpw_LAT_posedge                :	VitalDelayType := 1.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLAT : entity is TRUE;
end DLAT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DLAT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_negedge,
          TimingData              => Tmkr_D_LAT_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLAT",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT,
          PeriodData              => PInfo_LAT,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DLAT",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_negedge or Pviol_LAT;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLAT_VITAL of DLAT is 
        for VITAL
        end for; 
end CFG_DLAT_VITAL;
----- VITAL model for cell DLATR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.0 ns;
      trecovery_R_LAT_posedge_negedge :	VitalDelayType := 0.1 ns;
      thold_R_LAT_posedge_negedge    :	VitalDelayType := 0.0 ns;
      ticd_LAT                       :	VitalDelayType := 0.0 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.0 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.0 ns;
      tipd_D                         :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_R                         :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATR : entity is TRUE;
end DLATR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DLATR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_negedge,
          TimingData              => Tmkr_R_LAT_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_posedge_negedge,
          Removal                 => thold_R_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_1,
          PeriodData              => PInfo_LAT_R_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly ) = '1',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_R_EQ_1_negedge or Tviol_R_LAT_negedge or Pviol_LAT_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_LAT_dly,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATR_VITAL of DLATR is 
        for VITAL
        end for; 
end CFG_DLATR_VITAL;
----- VITAL model for cell DLATRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.1 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.0 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_R_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRH : entity is TRUE;
end DLATRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DLATRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((R_LAT_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_negedge,
          TimingData              => Tmkr_R_LAT_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_negedge_negedge,
          Removal                 => thold_R_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_0,
          PeriodData              => PInfo_LAT_R_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_R_EQ_0_negedge or Tviol_R_LAT_negedge or Pviol_LAT_R_EQ_0;
      R_inverted := (NOT R_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,R_inverted,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRH_VITAL of DLATRH is 
        for VITAL
        end for; 
end CFG_DLATRH_VITAL;
----- VITAL model for cell DLATRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_negedge :	VitalDelayType := 1.000 ns;
      tpw_S_negedge :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge  :	VitalDelayType := 1.000 ns;
      trecovery_R_LAT_posedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_posedge_negedge :	VitalDelayType := 0.000 ns;
      trecovery_S_LAT_posedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_posedge_negedge :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRS : entity is TRUE;
end DLATRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DLATRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_R_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_R_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_1_ANB_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_1_ANB_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   VARIABLE NOT_S_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((S_LAT_dly) AND (R_LAT_dly)) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_S_EQ_1_negedge,
          TimingData              => Tmkr_R_LAT_S_EQ_1_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_posedge_negedge,
          Removal                 => thold_R_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_R_EQ_1_negedge,
          TimingData              => Tmkr_S_LAT_R_EQ_1_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_posedge_negedge,
          Removal                 => thold_S_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_1_ANB_S_EQ_1,
          PeriodData              => PInfo_LAT_R_EQ_1_ANB_S_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_LAT_dly ) AND ( R_LAT_dly ) ) = '1',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------

        NOT_S_zd := VitalINV (S_LAT_dly);
        D_in_zd := VitalOR2 (NOT_S_zd , D_LAT_dly);

      Violation := Tviol_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge or Tviol_S_LAT_R_EQ_1_negedge or Pviol_LAT_R_EQ_1_ANB_S_EQ_1 or Tviol_R_LAT_S_EQ_1_negedge;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_LAT_dly, S_LAT_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE),
                 3 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRS_VITAL of DLATRS is 
        for VITAL
        end for; 
end CFG_DLATRS_VITAL;
----- VITAL model for cell DLATRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_posedge :	VitalDelayType := 1.000 ns;
      tpw_S_posedge :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge  :	VitalDelayType := 1.000 ns;
      trecovery_R_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_negedge_negedge     :	VitalDelayType := 0.000 ns;
      trecovery_S_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_negedge_negedge     :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRSH : entity is TRUE;
end DLATRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DLATRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_0_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R : STD_ULOGIC := '0';
   VARIABLE Pviol_S : STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_0_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_LAT_dly)) AND ((NOT R_LAT_dly))) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_S_EQ_0_negedge,
          TimingData              => Tmkr_R_LAT_S_EQ_0_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_negedge_negedge,
          Removal                 => thold_R_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_R_EQ_0_negedge,
          TimingData              => Tmkr_S_LAT_R_EQ_0_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_negedge_negedge,
          Removal                 => thold_S_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_0_ANB_S_EQ_0,
          PeriodData              => PInfo_LAT_R_EQ_0_ANB_S_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(((NOT S_LAT_dly)) AND ((NOT R_LAT_dly))) = '1',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------

        D_in_zd := VitalOR2 (S_LAT_dly , D_LAT_dly);

      Violation := Tviol_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge or Tviol_R_LAT_S_EQ_0_negedge or Tviol_S_LAT_R_EQ_0_negedge or Pviol_LAT_R_EQ_0_ANB_S_EQ_0 or Pviol_R or Pviol_S;
      S_inverted := (NOT S_LAT_dly);
      R_inverted := (NOT R_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_inverted, S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE),
                 3 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRSH_VITAL of DLATRSH is 
        for VITAL
        end for; 
end CFG_DLATRSH_VITAL;
----- VITAL model for cell DLATS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.0 ns;
      trecovery_S_LAT_posedge_negedge :	VitalDelayType := 0.1 ns;
      thold_S_LAT_posedge_negedge    :	VitalDelayType := 0.0 ns;
      ticd_LAT                       :	VitalDelayType := 0.0 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.0 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.0 ns;
      tipd_D                         :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_S                         :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATS : entity is TRUE;
end DLATS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DLATS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_S_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_S_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_negedge,
          TimingData              => Tmkr_S_LAT_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_posedge_negedge,
          Removal                 => thold_S_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_S_EQ_1,
          PeriodData              => PInfo_LAT_S_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly ) = '1',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_S_EQ_1_negedge or Tviol_S_LAT_negedge or Pviol_LAT_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,'1', S_LAT_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATS_VITAL of DLATS is 
        for VITAL
        end for; 
end CFG_DLATS_VITAL;
----- VITAL model for cell DLATSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.1 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.0 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.000 ns;
      tpw_S_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_S_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATSH : entity is TRUE;
end DLATSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of DLATSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_S_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_S_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((S_LAT_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_negedge,
          TimingData              => Tmkr_S_LAT_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_negedge_negedge,
          Removal                 => thold_S_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_S_EQ_0,
          PeriodData              => PInfo_LAT_S_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((S_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_S_EQ_0_negedge or Tviol_S_LAT_negedge or Pviol_LAT_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, '1',S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATSH_VITAL of DLATSH is 
        for VITAL
        end for; 
end CFG_DLATSH_VITAL;
----- VITAL model for cell GND -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GND is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True);

   port(
      X                              :	out   STD_ULOGIC := '0');
attribute VITAL_LEVEL0 of GND : entity is TRUE;
end GND;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of GND is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

	SIGNAL SUPPLY0    :   STD_ULOGIC := '0';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   --  empty
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------

Inst1 : VitalBUF (X,SUPPLY0);

end VITAL;

configuration CFG_GND_VITAL of GND is 
        for VITAL
        end for; 
end CFG_GND_VITAL;
----- VITAL model for cell GSRBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GSRBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_SRI_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_SRI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      SRI                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GSRBUF : entity is TRUE;
end GSRBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of GSRBUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL SRI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (SRI_ipd, SRI, tipd_SRI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (SRI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(SRI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (SRI_ipd'last_event, tpd_SRI_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_GSRBUF_VITAL of GSRBUF is 
        for VITAL
        end for; 
end CFG_GSRBUF_VITAL;

----- VITAL model for cell IBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity IBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      PULL           : string  := "Off";
      tpd_I0_O                       :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of IBUF : entity is TRUE;
end IBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of IBUF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_ULOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_ULOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
        if (PULL = "Off") then
           O_zd := TO_X01(I0_ipd);
        elsif (PULL = "Up") then
           CASE TO_X01Z(I0_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '1';
              WHEN others => O_zd := 'X';
           END CASE;
        elsif (PULL = "Down") then
           CASE TO_X01Z(I0_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '0';
              WHEN others => O_zd := 'X';
           END CASE;
        elsif (PULL = "Hold") then
           CASE TO_X01Z(I0_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := O_zd;
              WHEN others => O_zd := 'X';
           END CASE;
        end if;
      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_IBUF_VITAL of IBUF is 
        for VITAL
        end for; 
end CFG_IBUF_VITAL;


----- VITAL model for cell INV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity INV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INV : entity is TRUE;
end INV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of INV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_INV_VITAL of INV is 
        for VITAL
        end for; 
end CFG_INV_VITAL;

----- VITAL model for cell INVTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity INVTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      OUTOPEN        : string := "Off";
      tpd_OE_O                       :	VitalDelayType01z := (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INVTH : entity is TRUE;
end INVTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of INVTH is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);
   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;
   VARIABLE I0_inv          : STD_ULOGIC := 'X';

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       I0_inv := not I0_ipd;

       if (OE = '0') then
          O_zd := 'Z';
       elsif (OE = '1') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_inv);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_inv = '0') then
              O_zd := '0';
           elsif (I0_inv = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;


      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_INVTH_VITAL of INVTH is 
        for VITAL
        end for; 
end CFG_INVTH_VITAL;

----- VITAL model for cell INVTL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity INVTL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      OUTOPEN        : string := "Off";
      tpd_OE_O                       :	VitalDelayType01z := (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INVTL : entity is TRUE;
end INVTL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of INVTL is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;
   VARIABLE I0_inv          : STD_ULOGIC := 'X';

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       I0_inv := not I0_ipd;

       if (OE = '1') then
          O_zd := 'Z';
       elsif (OE = '0') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_inv);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_inv = '0') then
              O_zd := '0';
           elsif (I0_inv = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_INVTL_VITAL of INVTL is 
        for VITAL
        end for; 
end CFG_INVTL_VITAL;

----- VITAL model for cell NAN2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN2 : entity is TRUE;
end NAN2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of NAN2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) OR ((NOT I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN2_VITAL of NAN2 is 
        for VITAL
        end for; 
end CFG_NAN2_VITAL;
----- VITAL model for cell NAN3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I1                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I2                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN3 : entity is TRUE;
end NAN3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of NAN3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN3_VITAL of NAN3 is 
        for VITAL
        end for; 
end CFG_NAN3_VITAL;
----- VITAL model for cell NAN4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN4 : entity is TRUE;
end NAN4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of NAN4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN4_VITAL of NAN4 is 
        for VITAL
        end for; 
end CFG_NAN4_VITAL;
----- VITAL model for cell NAN5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN5 : entity is TRUE;
end NAN5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of NAN5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN5_VITAL of NAN5 is 
        for VITAL
        end for; 
end CFG_NAN5_VITAL;
----- VITAL model for cell NAN6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN6 : entity is TRUE;
end NAN6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of NAN6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd)) OR ((NOT I5_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NAN6_VITAL of NAN6 is 
        for VITAL
        end for; 
end CFG_NAN6_VITAL;
----- VITAL model for cell NAN7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN7 : entity is TRUE;
end NAN7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of NAN7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd)) OR ((NOT I5_ipd)) OR ((NOT I6_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NAN7_VITAL of NAN7 is 
        for VITAL
        end for; 
end CFG_NAN7_VITAL;
----- VITAL model for cell NAN8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN8 : entity is TRUE;
end NAN8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of NAN8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd)) OR ((NOT I5_ipd)) OR ((NOT I6_ipd)) OR ((NOT
         I7_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NAN8_VITAL of NAN8 is 
        for VITAL
        end for; 
end CFG_NAN8_VITAL;

----- VITAL model for cell NOR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I1                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR2 : entity is TRUE;
end NOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of NOR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) AND ((NOT I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NOR2_VITAL of NOR2 is 
        for VITAL
        end for; 
end CFG_NOR2_VITAL;
----- VITAL model for cell NOR3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR3 : entity is TRUE;
end NOR3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of NOR3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NOR3_VITAL of NOR3 is 
        for VITAL
        end for; 
end CFG_NOR3_VITAL;
----- VITAL model for cell NOR4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR4 : entity is TRUE;
end NOR4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of NOR4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NOR4_VITAL of NOR4 is 
        for VITAL
        end for; 
end CFG_NOR4_VITAL;
----- VITAL model for cell NOR5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR5 : entity is TRUE;
end NOR5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of NOR5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR5_VITAL of NOR5 is 
        for VITAL
        end for; 
end CFG_NOR5_VITAL;
----- VITAL model for cell NOR6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR6 : entity is TRUE;
end NOR6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of NOR6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd)) AND ((NOT I5_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR6_VITAL of NOR6 is 
        for VITAL
        end for; 
end CFG_NOR6_VITAL;
----- VITAL model for cell NOR7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR7 : entity is TRUE;
end NOR7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of NOR7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd)) AND ((NOT I5_ipd)) AND ((NOT I6_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR7_VITAL of NOR7 is 
        for VITAL
        end for; 
end CFG_NOR7_VITAL;
----- VITAL model for cell NOR8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR8 : entity is TRUE;
end NOR8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of NOR8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd)) AND ((NOT I5_ipd)) AND ((NOT I6_ipd))
         AND ((NOT I7_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR8_VITAL of NOR8 is 
        for VITAL
        end for; 
end CFG_NOR8_VITAL;

----- VITAL model for cell OBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity OBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN          : string  := "Off";
      PULL             : string  := "Off";
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OBUF : entity is TRUE;
end OBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of OBUF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_ipd);
       elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_ipd = '0') then
              O_zd := '0';
           elsif (I0_ipd = '1') then
            if (PULL = "Off") then
              O_zd := 'Z';
            elsif (PULL = "Up") then
              O_zd := 'H';
            elsif (PULL = "Down") then
              O_zd := 'L';              
            elsif (PULL = "Hold") then
              O_zd := O_zd;              
            else
              O_zd := 'Z';            
            end if;          
           else
              O_zd := 'X';
           end if;
       end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OBUF_VITAL of OBUF is 
        for VITAL
        end for; 
end CFG_OBUF_VITAL;

----- VITAL model for cell OR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR2 : entity is TRUE;
end OR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of OR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OR2_VITAL of OR2 is 
        for VITAL
        end for; 
end CFG_OR2_VITAL;
----- VITAL model for cell OR3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR3 : entity is TRUE;
end OR3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of OR3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd) OR (I2_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OR3_VITAL of OR3 is 
        for VITAL
        end for; 
end CFG_OR3_VITAL;
----- VITAL model for cell OR4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR4 : entity is TRUE;
end OR4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of OR4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OR4_VITAL of OR4 is 
        for VITAL
        end for; 
end CFG_OR4_VITAL;
----- VITAL model for cell OR5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR5 : entity is TRUE;
end OR5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of OR5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR5_VITAL of OR5 is 
        for VITAL
        end for; 
end CFG_OR5_VITAL;
----- VITAL model for cell OR6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR6 : entity is TRUE;
end OR6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of OR6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd) OR (I5_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR6_VITAL of OR6 is 
        for VITAL
        end for; 
end CFG_OR6_VITAL;
----- VITAL model for cell OR7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR7 : entity is TRUE;
end OR7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of OR7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd) OR (I5_ipd)
         OR (I6_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR7_VITAL of OR7 is 
        for VITAL
        end for; 
end CFG_OR7_VITAL;
----- VITAL model for cell OR8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR8 : entity is TRUE;
end OR8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library MACH;
architecture VITAL of OR8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd) OR (I5_ipd)
         OR (I6_ipd) OR (I7_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR8_VITAL of OR8 is 
        for VITAL
        end for; 
end CFG_OR8_VITAL;

----- VITAL model for cell TFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge    :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge     :	VitalDelayType := 0.0 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 1.0 ns;
      tpw_CLK_posedge                :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFF : entity is TRUE;
end TFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of TFF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => '0');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_posedge,
          TimingData              => Tmkr_T_CLK_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/TFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, '1', '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFF_VITAL of TFF is 
        for VITAL
        end for; 
end CFG_TFF_VITAL;
----- VITAL model for cell TFFR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_posedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFR : entity is TRUE;
end TFFR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of TFFR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_1_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/TFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1 or Tviol_R_CLK_posedge;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, '1', R_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFR_VITAL of TFFR is 
        for VITAL
        end for; 
end CFG_TFFR_VITAL;
----- VITAL model for cell TFFRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_negedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tpw_R_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFRH : entity is TRUE;
end TFFRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of TFFRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_0_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_0_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_0;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, '1', R_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFRH_VITAL of TFFRH is 
        for VITAL
        end for; 
end CFG_TFFRH_VITAL;
----- VITAL model for cell TFFRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity TFFRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q             :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q             :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q           :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.0 ns;
      tpw_R_negedge :	VitalDelayType := 1.0 ns;
      tpw_S_negedge :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge   :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFRS : entity is TRUE;
end TFFRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of TFFRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1_AN_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1_AN_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE T_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1_AN_S_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1_AN_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( (NOT S_CLK_dly) ) OR ( (NOT R_CLK_dly) )
                            ) /= '1',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_1_AN_S_EQ_1_posedge or Tviol_R_CLK_S_EQ_1_posedge or Tviol_S_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1_AN_S_EQ_1 or Pviol_R or Pviol_s;
      T_delayed := T_CLK_dly;
      CLK_delayed := CLK_dly;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly,S_CLK_dly, R_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFRS_VITAL of TFFRS is 
        for VITAL
        end for; 
end CFG_TFFRS_VITAL;
----- VITAL model for cell TFFRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity TFFRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.0 ns;
      tpw_R_posedge :	VitalDelayType := 1.0 ns;
      tpw_S_posedge :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge   :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFRSH : entity is TRUE;
end TFFRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of TFFRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0_AN_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0_AN_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE T_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND ((NOT R_CLK_dly))) /=
                            '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT S_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0_AN_S_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0_AN_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_CLK_dly ) OR ( R_CLK_dly ) ) /= '1',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_0_AN_S_EQ_0_posedge or Tviol_S_CLK_R_EQ_0_posedge or Pviol_CLK_R_EQ_0_AN_S_EQ_0 or Tviol_R_CLK_S_EQ_0_posedge or Pviol_R or Pviol_S;
      T_delayed := T_CLK_dly;
      CLK_delayed := CLK_dly;
      S_inverted := NOT S_CLK_dly;
      R_inverted := NOT R_CLK_dly;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly,S_inverted, R_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFRSH_VITAL of TFFRSH is 
        for VITAL
        end for; 
end CFG_TFFRSH_VITAL;
----- VITAL model for cell TFFS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_posedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFS : entity is TRUE;
end TFFS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of TFFS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_T_CLK_S_EQ_1_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_1,
          PeriodData              => PInfo_CLK_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/TFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_S_EQ_1_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, S_CLK_dly, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFS_VITAL of TFFS is 
        for VITAL
        end for; 
end CFG_TFFS_VITAL;
----- VITAL model for cell TFFSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_negedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tpw_S_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFSH : entity is TRUE;
end TFFSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of TFFSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_T_CLK_S_EQ_0_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_0,
          PeriodData              => PInfo_CLK_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_S_EQ_0_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, S_inverted, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFSH_VITAL of TFFSH is 
        for VITAL
        end for; 
end CFG_TFFSH_VITAL;
----- VITAL model for cell VCC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity VCC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True);

   port(
      X                              :	out   STD_ULOGIC := '1');
attribute VITAL_LEVEL0 of VCC : entity is TRUE;
end VCC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of VCC is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;
   
   SIGNAL SUPPLY1  : STD_ULOGIC := '1'; 

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   --  empty
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------

Inst1: VitalBUF (X,SUPPLY1);

end VITAL;

configuration CFG_VCC_VITAL of VCC is 
        for VITAL
        end for; 
end CFG_VCC_VITAL;

----- VITAL model for cell XOR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity XOR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of XOR2 : entity is TRUE;

   -- real names
   -- REAL_NAME of XOR2 is "XOR2"
end XOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of XOR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (((NOT I0_ipd)) AND (I1_ipd)) OR (((NOT I1_ipd)) AND (I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_XOR2_VITAL of XOR2 is 
        for VITAL
        end for; 
end CFG_XOR2_VITAL;

----- VITAL model for cell XORSOFT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity XORSOFT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of XORSOFT : entity is TRUE;
end XORSOFT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of XORSOFT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (((NOT I0_ipd)) AND (I1_ipd)) OR (((NOT I1_ipd)) AND (I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_XORSOFT_VITAL of XORSOFT is 
        for VITAL
        end for; 
end CFG_XORSOFT_VITAL;



library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity SPLL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      IN_FREQ: STRING := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN                    :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of SPLL : entity is FALSE;
end SPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of SPLL is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(CLK_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => CLK_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "CLK_OUT",
       OutTemp => O_zd,
       Paths => (0 => (CLK_IN_ipd'last_event, tpd_CLK_IN_CLK_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_SPLL_VITAL of SPLL is 
        for VITAL
        end for; 
end CFG_SPLL_VITAL;

----- VITAL model for cell STDPLL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library MACH;
use MACH.components.all;

-- entity declaration --
entity STDPLL is
   generic(
      IN_FREQ  : string  := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      SECDIV   : string  := "1";
      lock_cyc : integer := 2;
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_PLL_LOCK             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN             :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC;
      PLL_LOCK                       :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLL : entity is FALSE;
end STDPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
use MACH.components.all;
architecture VITAL of STDPLL is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';
  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)/clockboost;
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     elsif clklock_rising_edge_count = 2 THEN
       clklock_half_period_minus_dly0 <= clklock_half_period0 + tpd;
       clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;
     END IF;
     END IF;
 
  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)/clockboost; 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= clklock_half_period1 + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
      if(clockboost >1.0) then
	FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	END LOOP;
      else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
      end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
end process;

process
begin
   wait until clock_count >= 1;
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
end process;

process
begin
   wait until (clklock_falling_edge_count >= lock_cyc + 1);
    wait for clklock_half_period_minus_dly0;
   CLK_OUT_start <= '1';
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;


    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay;

    PLL_LOCK <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus;
               


end VITAL;

configuration CFG_STDPLL_VITAL of STDPLL is 
        for VITAL
        end for; 
end CFG_STDPLL_VITAL;

----- VITAL model for cell STDPLLX -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library MACH;
use MACH.components.all;

-- entity declaration --
entity STDPLLX is
   generic(
      IN_FREQ  : string  := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      LOCK_CYC : integer := 2;
      SECDIV   : string   := "1";
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_PLL_RST_PLL_LOCK :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_PLL_LOCK             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_SEC_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_FBK   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_RST   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN            : in    STD_ULOGIC;
      PLL_FBK           : in    STD_ULOGIC;
      PLL_RST           : in    STD_ULOGIC;
      CLK_OUT           : out   STD_ULOGIC;
      SEC_OUT           : out   STD_ULOGIC;
      PLL_LOCK          : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLLX : entity is FALSE;
end STDPLLX;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
use MACH.components.all;


architecture VITAL of STDPLLX is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL PLL_RST_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL secd_delay_minus1 : TIME :=100 ns;
  SIGNAL secd_delay_minus0 : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';

  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';

  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  CONSTANT secdiv_p: integer := str2int(secdiv);
  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   VitalWireDelay (PLL_RST_ipd, PLL_RST, tipd_PLL_RST);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)/clockboost;
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     elsif clklock_rising_edge_count = 2 THEN
       clklock_half_period_minus_dly0 <= clklock_half_period0 + tpd;
       clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;
        secd_delay_minus0 <= clklock_half_period0 * secdiv_p + tpd;
     END IF;
     END IF;
 
  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)/clockboost; 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= clklock_half_period1 + tpd;
        secd_delay_minus1 <= clklock_half_period1 * secdiv_p + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc and PLL_RST_ipd ='0' THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

process
begin
   wait until clock_count >= 1;
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
end process;

process
begin
   wait until (clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_ipd = '0');
    wait for clklock_half_period_minus_dly0;
   CLK_OUT_start <= '1';
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;

process
begin
   wait until clock_count >= 1;
     wait for clklock_half_period1 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not;
     wait for clklock_half_period0 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not ;
end process;

process
begin
   wait until clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_ipd = '0';
    wait for secd_delay_minus0;
   SEC_OUT_start <= '1';
end process;

process
begin
   wait until  SEC_OUT_start = '1'; LOOP
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d;
     wait for clklock_half_period1 * secdiv_p;
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d ;
     wait for clklock_half_period0 * secdiv_p;
     END LOOP;
end process;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay and not PLL_RST_ipd;

    PLL_LOCK <= PLL_LOCK_plus and not PLL_RST_ipd when tpd >= 0 ns else
                PLL_LOCK_minus and  not PLL_RST_ipd;

    SEC_OUT_sig_d <= SEC_OUT_sig_d_start and not SEC_OUT_sig_d_not; 

    SEC_OUT_plus_delay <= SEC_OUT_sig_d after tpd when tpd >= 0 ns else
                          SEC_OUT_sig_3d; 

    SEC_OUT <= SEC_OUT_plus_delay and not PLL_RST_ipd;

end VITAL;

configuration CFG_STDPLLX_VITAL of STDPLLX is 
        for VITAL
        end for; 
end CFG_STDPLLX_VITAL;

----- VITAL model for cell LVDSIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_PIN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_NIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      NIN                            :	in    STD_ULOGIC;
      PIN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSIN : entity is TRUE;
end LVDSIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
-- -- use MACH.VTABLES.all;
architecture VITAL of LVDSIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL PIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (PIN_ipd, PIN, tipd_PIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (PIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(PIN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (PIN_ipd'last_event, tpd_PIN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSIN_VITAL of LVDSIN is 
        for VITAL
        end for; 
end CFG_LVDSIN_VITAL;

----- VITAL model for cell LVDSOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity LVDSOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_POUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      POUT                             :	out   STD_ULOGIC;
      NOUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSOUT : entity is TRUE;
end LVDSOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
-- use MACH.VTABLES.all;
architecture VITAL of LVDSOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => POUT,
       GlitchData => O_GlitchData,
       OutSignalName => "POUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_POUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSOUT_VITAL of LVDSOUT is 
        for VITAL
        end for; 
end CFG_LVDSOUT_VITAL;

----- VITAL model for cell LVDSTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_POUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_POUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      POUT                          :	out   STD_ULOGIC;
      NOUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSTRI : entity is TRUE;
end LVDSTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
--use MACH.VTABLES.all;
architecture VITAL of LVDSTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => POUT,
       GlitchData => O_GlitchData,
       OutSignalName => "POUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_POUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_POUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_LVDSTRI_VITAL of LVDSTRI is 
        for VITAL
        end for; 
end CFG_LVDSTRI_VITAL;

--------------------------------------------------------------------------------
----- VITAL model for cell PG -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY MACH ;
use MACH.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity PG is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_E_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_E_noedge_negedge      :	VitalDelayType := 0.100 ns;
      thold_D_E_noedge_negedge       :	VitalDelayType := 0.000 ns;
      tperiod_E_posedge              :	VitalDelayType := 1.000 ns;
      tpw_E_posedge                  :	VitalDelayType := 1.000 ns;
      ticd_E                         :	VitalDelayType := 0.000 ns;
      tisd_D_E                       :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of PG : entity is TRUE;
end PG;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library MACH;
architecture VITAL of PG is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_ipd	 : STD_ULOGIC := 'X';
   SIGNAL E_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_E_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (E_ipd, E, tipd_E);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (E_dly, E_ipd, ticd_E);
   VitalSignalDelay (D_E_dly, D_ipd, tisd_D_E);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (E_dly, D_E_dly)

   -- timing check results
   VARIABLE Tviol_D_E_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_E_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_E	: STD_ULOGIC := '0';
   VARIABLE PInfo_E	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_E_negedge,
          TimingData              => Tmkr_D_E_negedge,
          TestSignal              => D_E_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_E,
          RefSignal               => E_dly,
          RefSignalName          => "E",
          RefDelay                => ticd_E,
          SetupHigh               => tsetup_D_E_noedge_negedge,
          SetupLow                => tsetup_D_E_noedge_negedge,
          HoldHigh                => thold_D_E_noedge_negedge,
          HoldLow                 => thold_D_E_noedge_negedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/E",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_E,
          PeriodData              => PInfo_E,
          TestSignal              => E_dly,
          TestSignalName          => "E",
          TestDelay               => ticd_E,
          Period                  => tperiod_E_posedge,
          PulseWidthHigh          => tpw_E_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/PG",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_E_negedge or Pviol_E;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_E_dly, E_dly,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_E_dly'last_event, tpd_D_Q, TRUE),
                 1 => (E_dly'last_event, tpd_E_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_PG_VITAL of PG is 
        for VITAL
        end for; 
end CFG_PG_VITAL;

----- cell OSCTIMER -----
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;
library MACH;
use MACH.components.all;
-- entity declaration --
entity OSCTIMER is
    generic (
        TIMER_DIV : string := "128";
        NORM_FREQ : string := "500";
        CO_DELAY  : string := "600";
        TimingChecksOn: Boolean := True;
        InstancePath: STRING := "*";
        Xon: Boolean := True;
        MsgOn: Boolean := True;
        tipd_DYNOSCDIS                  : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_TIMERRES                   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_DYNOSCDIS_OSCOUT            : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_TIMERRES_TIMEROUT           : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_OSCOUT_TIMEROUT             : VitalDelayType01 := (0.000 ns, 0.000 ns);
	tsetup_DYNOSCDIS_OSCOUT_posedge_negedge : VitalDelayType := 0.000 ns;
        thold_DYNOSCDIS_OSCOUT_posedge_negedge	: VitalDelayType := 0.000 ns;
        tpw_TIMERRES_posedge 		:	VitalDelayType := 1.000 ns;
        tperiod_OSCOUT_negedge 		:	VitalDelayType := 1.000 ns;
        trecovery_TIMERRES_OSCOUT_negedge_negedge : VitalDelayType := 0.100 ns;
        thold_TIMERRES_OSCOUT_negedge_negedge	  : VitalDelayType := 0.000 ns;
        ticd_OSCOUT                     : VitalDelayType   := 0.000 ns;
        tisd_DYNOSCDIS_OSCOUT           : VitalDelayType   := 0.000 ns;
        tisd_TIMERRES_OSCOUT            : VitalDelayType   := 0.000 ns
     );
   port(
      DYNOSCDIS                      :	in    STD_ULOGIC;
      TIMERRES                       :	in    STD_ULOGIC;
      OSCOUT                         :	out   STD_ULOGIC;      
      TIMEROUT                       :	out   STD_ULOGIC);
   attribute VITAL_LEVEL0 of OSCTIMER : entity is TRUE;
end OSCTIMER ;

-- architecture body --
architecture VITAL of OSCTIMER is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

	CONSTANT NORM_FREQ_c		: Time := 1.0 ns * 50000 / str2int(NORM_FREQ);
	CONSTANT CO_DELAY_c		: Time := 1.0 ns * str2int(CO_DELAY)/100;
   	signal DYNOSCDIS_ipd	 	: STD_ULOGIC := 'X';
	signal TIMERRES_ipd		: STD_ULOGIC := 'X';
   	signal OSCOUT_dly		: STD_ULOGIC := 'X';
   	signal DYNOSCDIS_OSCOUT_dly	: STD_ULOGIC := 'X';
   	signal DYNOSCDIS_TIMEROUT_dly	: STD_ULOGIC := 'X';
	signal TIMERRES_TIMEROUT_dly	: STD_ULOGIC := 'X';
	signal TIMERRES_OSCOUT_dly	: STD_ULOGIC := 'X';

	signal OSCOUT_s          	: STD_ULOGIC;  
	signal CNTRES_s          	: STD_ULOGIC;  
	signal CNT_s             	: STD_LOGIC_VECTOR(19 downto 0); 
	signal TIMEROUT_s	 	: STD_ULOGIC := 'X';
	signal OUT_bit           	: INTEGER := 6; 

BEGIN
   WireDelay : block
   begin
   VitalWireDelay (DYNOSCDIS_ipd, DYNOSCDIS, tipd_DYNOSCDIS);
   VitalWireDelay (TIMERRES_ipd, TIMERRES, tipd_TIMERRES);
   end block;

   SignalDelay : block
   begin
   VitalSignalDelay (OSCOUT_dly, OSCOUT_s, ticd_OSCOUT);
   VitalSignalDelay (DYNOSCDIS_OSCOUT_dly, DYNOSCDIS_ipd, tisd_DYNOSCDIS_OSCOUT);
   VitalSignalDelay (TIMERRES_OSCOUT_dly, TIMERRES_ipd, tisd_TIMERRES_OSCOUT);
   end block;

   process
   begin
      IF (TIMER_DIV = "128") then
         OUT_bit <= 6;
      ELSIF (TIMER_DIV = "1024") then
         OUT_bit <= 9;
      ELSIF (TIMER_DIV = "1048576") then
         OUT_bit <= 19;
      end IF;
      wait;
   end PROCESS;

   OSCOUT <= OSCOUT_dly;
   TIMEROUT_s <= CNT_s(OUT_bit) after CO_DELAY_c;

   OSC : process
   begin
      wait until (DYNOSCDIS_OSCOUT_dly = '0');
      while (DYNOSCDIS_OSCOUT_dly = '0') loop 	
      OSCOUT_s <= '0';
      wait for NORM_FREQ_c;
      OSCOUT_s <= '1';
      wait for NORM_FREQ_c;
      OSCOUT_s <= '0';
      end loop;
   end process;

   TIMER_RES : process (OSCOUT_s) 
   begin
      if falling_edge (OSCOUT_s) then
	 if(TIMERRES_OSCOUT_dly ='1' or DYNOSCDIS_OSCOUT_dly = '1' ) then
           CNTRES_s <= '1';
         else
           CNTRES_s <= '0';
         end if;
      end if;
   end process;

   TIMER_20bit: process (OSCOUT_s,CNTRES_s)
      variable CNT_v : integer := 0;
      begin
        if (CNTRES_s = '1') then
              CNT_v := 0;
	      CNT_s <= (others => '0');
	elsif falling_edge (OSCOUT_s) then
           if (CNT_v = str2int(TIMER_DIV)-1) then
              CNT_v := 0;
	      CNT_s <= (others => '0');
	   else
	      CNT_v := CNT_v + 1;
	      CNT_s <= CNT_s + "00000000000000000001";
	   end if;
        end if;
   end process;


   VITALBehavior : process (OSCOUT_s,TIMEROUT_s)
   -- timing check results
   VARIABLE Tviol_DYNOSCDIS_OSCOUT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_DYNOSCDIS_OSCOUT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_TIMERRES_OSCOUT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_TIMERRES_OSCOUT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_TIMERRES			: STD_ULOGIC := '0';
   VARIABLE PInfo_TIMERRES			: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE Pviol_OSCOUT			: STD_ULOGIC := '0';
   VARIABLE PInfo_OSCOUT			: VitalPeriodDataType := VitalPeriodDataInit;

   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE TIMEROUT_GlitchData	: VitalGlitchDataType;

   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS TIMEROUT_zd : STD_LOGIC is Results(1);

   begin
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_DYNOSCDIS_OSCOUT_negedge,
          TimingData              => Tmkr_DYNOSCDIS_OSCOUT_negedge,
          TestSignal              => DYNOSCDIS_OSCOUT_dly,
          TestSignalName          => "DYNOSCDIS",
          TestDelay               => tisd_DYNOSCDIS_OSCOUT,
          RefSignal               => OSCOUT_dly,
          RefSignalName           => "OSCOUT",
          RefDelay                => ticd_OSCOUT,
          SetupHigh               => tsetup_DYNOSCDIS_OSCOUT_posedge_negedge,
          SetupLow                => tsetup_DYNOSCDIS_OSCOUT_posedge_negedge,
          HoldHigh                => thold_DYNOSCDIS_OSCOUT_posedge_negedge,
          HoldLow                 => thold_DYNOSCDIS_OSCOUT_posedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/OSCTIMER",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

        VitalRecoveryRemovalCheck (
          Violation               => Tviol_TIMERRES_OSCOUT_negedge,
          TimingData              => Tmkr_TIMERRES_OSCOUT_negedge,
          TestSignal              => TIMERRES_OSCOUT_dly,
          TestSignalName          => "TIMERRES",
          TestDelay               => tisd_TIMERRES_OSCOUT,
          RefSignal               => OSCOUT_dly,
          RefSignalName           => "OSCOUT",
          RefDelay                => ticd_OSCOUT,
          Recovery                => trecovery_TIMERRES_OSCOUT_negedge_negedge,
          Removal                 => thold_TIMERRES_OSCOUT_negedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/OSCTIMER",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

       VitalPeriodPulseCheck (
          Violation               => Pviol_TIMERRES,
          PeriodData              => PInfo_TIMERRES,
          TestSignal              => TIMERRES_OSCOUT_dly,
          TestSignalName          => "TIMERRES",
          TestDelay               => tisd_TIMERRES_OSCOUT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_TIMERRES_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/OSCTIMER",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

       VitalPeriodPulseCheck (
          Violation               => Pviol_OSCOUT,
          PeriodData              => PInfo_OSCOUT,
          TestSignal              => OSCOUT_dly,
          TestSignalName          => "OSCOUT",
          TestDelay               => ticd_OSCOUT,
          Period                  => tperiod_OSCOUT_negedge,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/OSCTIMER",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_DYNOSCDIS_OSCOUT_negedge or Tviol_DYNOSCDIS_OSCOUT_negedge;
      TIMEROUT_zd := Violation XOR TIMEROUT_s;

      VitalPathDelay01 (
       OutSignal => TIMEROUT,
       GlitchData => TIMEROUT_GlitchData,
       OutSignalName => "TIMEROUT",
       OutTemp => TIMEROUT_zd,
       Paths => (0 => (DYNOSCDIS_OSCOUT_dly'last_event, tpd_DYNOSCDIS_OSCOUT, TRUE),
		 1 => (TIMERRES_TIMEROUT_dly'last_event, tpd_TIMERRES_TIMEROUT, TRUE),
                 2 => (OSCOUT_dly'last_event, tpd_OSCOUT_TIMEROUT, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;



end VITAL;

configuration CFG_OSCTIMER_VITAL of OSCTIMER is 
        for VITAL
        end for; 
end CFG_OSCTIMER_VITAL;

